/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.mixin.spellweave;

import com.github.jarva.arsadditions.datagen.EnchantmentDatagen;
import com.github.jarva.arsadditions.setup.registry.AddonDataComponentRegistry;
import com.hollingsworth.arsnouveau.api.perk.PerkSlot;
import com.hollingsworth.arsnouveau.common.block.AlterationTable;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={AlterationTable.class})
public class AlterationTableMixin {
    @WrapOperation(method={"useItemOn"}, at={@At(value="INVOKE", target="Lcom/hollingsworth/arsnouveau/api/util/PerkUtil;getPerkHolder(Lnet/minecraft/world/item/ItemStack;)Lcom/hollingsworth/arsnouveau/common/items/data/ArmorPerkHolder;")})
    private ArmorPerkHolder useItemOn(ItemStack stack, Operation<ArmorPerkHolder> original, @Local(argsOnly=true) Level level) {
        ArmorPerkHolder def = (ArmorPerkHolder)original.call(new Object[]{stack});
        if (!(stack.getItem() instanceof ArmorItem)) {
            return def;
        }
        List<Integer> values = PerkSlot.PERK_SLOTS.values().stream().map(PerkSlot::value).toList();
        Integer max = values.stream().max(Integer::compareTo).orElse(3);
        Integer enchantment = level.registryAccess().lookup(Registries.ENCHANTMENT).flatMap(registry -> registry.get(EnchantmentDatagen.SPELLWEAVE_ENCHANTMENT)).map(arg_0 -> ((ItemStack)stack).getEnchantmentLevel(arg_0)).map(eLevel -> Math.clamp((long)eLevel.intValue(), 0, max)).orElse(null);
        if (enchantment == null || enchantment <= 0) {
            return def;
        }
        stack.set(AddonDataComponentRegistry.OVERRIDE_PERKS, (Object)true);
        return (ArmorPerkHolder)stack.update((Supplier)DataComponentRegistry.ARMOR_PERKS, (Object)new ArmorPerkHolder(), holder -> {
            holder.setTier(enchantment.intValue());
            return holder;
        });
    }
}

